/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.addressrewrite;

// $Id:AddressRewriteTestCase.java,v 1.0, 2005-06-24 18:44:01Z, Robert Worsnop$

import junit.framework.Test;

import org.jboss.test.JBossTestCase;
import org.jboss.webservice.AxisServiceMBean;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * Test soap:address rewriting in the WSDL.
 *
 * @author jason.greene@jboss.com
 */
public class AddressRewriteTestCase extends JBossTestCase
{
   private final String WSDL_LOCATION = "http://" + getServerHost() + ":8080/ws4ee-addressrewrite/HelloPort?wsdl";
   private String NAMESPACE = "http://test.jboss.org/ws4eesimple";
   private final QName SERVICE_NAME = new QName(NAMESPACE, "HelloWsService");
   private AxisServiceMBean service = null;
   private boolean oldAlwaysModifySOAPAddress;

   /**
    * Construct the test case with a given name
    */
   public AddressRewriteTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(AddressRewriteTestCase.class, null);
   }


   public void setupService() throws Exception
   {
      MBeanServerConnection conn = (MBeanServerConnection) getServer();
      ObjectName name = new ObjectName("jboss.ws4ee:service=AxisService");
      service = (AxisServiceMBean) MBeanServerInvocationHandler.newProxyInstance(conn, name, AxisServiceMBean.class, false);
   }

   public void setUp() throws Exception
   {
      setupService();
      oldAlwaysModifySOAPAddress = service.isAlwaysModifySOAPAddress();
   }

   public void tearDown() throws Exception
   {
      delegate.undeploy("ws4ee-addressrewrite.war");
      service.setAlwaysModifySOAPAddress(oldAlwaysModifySOAPAddress);
   }

   public void setupAlwaysModify(boolean value) throws Exception
   {
      service.setAlwaysModifySOAPAddress(value);
      delegate.redeploy("ws4ee-addressrewrite.war");
   }

   public void testNoRewrite() throws Exception
   {
      setupAlwaysModify(false);
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
      Service service = serviceFactory.createService(new URL(WSDL_LOCATION), SERVICE_NAME);
      Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPortComponent"), "sayHello");
      assertEquals("http://this.really.is.not.valid", call.getTargetEndpointAddress());
   }

   public void testRewrite() throws Exception
   {
      setupAlwaysModify(true);
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
      Service service = serviceFactory.createService(new URL(WSDL_LOCATION), SERVICE_NAME);
      Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPortComponent"), "sayHello");
      assertTrue(! "http://this.really.is.not.valid".equals(call.getTargetEndpointAddress()));
   }
}