/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.util.test;

import java.io.File;
import java.util.Properties;

import org.jboss.test.JBossTestCase;
import org.jboss.util.StringPropertyReplacer;

/** Unit tests for the StringPropertyReplacer utility class

@see org.jboss.util.StringPropertyReplacer
@author Scott.Stark@jboss.org
@version $Revision:1$
**/
public class StringsUnitTestCase extends JBossTestCase
{
   public StringsUnitTestCase(String name)
   {
      super(name);
   }

   /** Tests of the ${x} property replacment
    * 
    * @throws Exception
    */ 
   public void testPropReplacement()
      throws Exception
   {
      getLog().debug("+++ testPropReplacement");
      String xref = "${x}";
      String xval = StringPropertyReplacer.replaceProperties(xref);
      assertTrue("xval == xref", xval.equals(xref));
      
      System.setProperty("x", "testPropReplacement");
      xval = StringPropertyReplacer.replaceProperties(xref);
      assertTrue("xval == 'xval'", xval.equals("testPropReplacement"));
   }

   /** Tests of the ${x} property replacment with a non-System Properties
    * 
    * @throws Exception
    */ 
   public void testNonSystemPropReplacement()
      throws Exception
   {
      getLog().debug("+++ testNonSystemPropReplacement");
      String xref = "${xx}";

      Properties props = new Properties();
      props.setProperty("xx", "testNonSystemPropReplacement");
      String xval = StringPropertyReplacer.replaceProperties(xref);
      xval = StringPropertyReplacer.replaceProperties(xref, props);
      assertTrue("xval == 'xval'", xval.equals("testNonSystemPropReplacement"));
   }

   /** Test that ${/} and ${:} refs are replaced with  
    * 
    * @throws Exception
    */ 
   public void testFilePropReplacement()
      throws Exception
   {
      getLog().debug("+++ testFilePropReplacement");
      String pathSeparatorRef = "${:}";
      String pathSeparator = StringPropertyReplacer.replaceProperties(pathSeparatorRef);
      String separatorRef = "${/}";
      String separator = StringPropertyReplacer.replaceProperties(separatorRef);
      getLog().debug("File.pathSeparator='"+File.pathSeparator+"'");
      getLog().debug("File.separator='"+File.separator+"'");
      assertTrue("${:}("+pathSeparator+") == File.pathSeparator", pathSeparator.equals(File.pathSeparator));
      assertTrue("${/}("+separator+") == File.separator", separator.equals(File.separator));
   }

   /** Override the initDelegate since these test don't need the JBoss server
    */
   public void initDelegate()
   {
   }

   public void testServerFound()
   {
   }
}
