/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:TimerTestBase.java,v 1.0, 2005-06-24 19:17:59Z, Robert Worsnop$

import junit.framework.TestCase;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb.txtimer.EJBTimerServiceLocator;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.test.txtimer.test.SimpleTimedObjectInvoker;

import javax.ejb.TimedObject;
import javax.ejb.TimerService;
import javax.management.ObjectName;

/**
 * Created by IntelliJ IDEA.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public abstract class TimerTestBase extends TestCase
{
   protected EJBTimerService ejbTimerService;

   protected TimerTestBase(String name)
   {
      super(name);
   }

   /**
    * Sets up the fixture, for example, open a network connection.
    * This method is called before a test is executed.
    */
   protected void setUp() throws Exception
   {
      super.setUp();
      ejbTimerService = EJBTimerServiceLocator.getEjbTimerService();

      // when the timer runs inside JBoss, this is taken care of by the container
      // is standalone mode, we fake the context for timer operations, so the timer thinks we are inside a EJB
      // business method, and does not refuse the operations
      AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsAssociation.IN_BUSINESS_METHOD);
   }

   /**
    * Tears down the fixture, for example, close a network connection.
    * This method is called after a test is executed.
    */
   protected void tearDown() throws Exception
   {
      super.tearDown();
      AllowedOperationsAssociation.popInMethodFlag();
   }

   protected TimerService createTimerService(TimedObject timedObject)
   {
      SimpleTimedObjectInvoker invoker = new SimpleTimedObjectInvoker();
      TimedObjectId timedObjectId = invoker.addTimedObject(timedObject);
      ObjectName containerId = timedObjectId.getContainerId();
      Object instancePk = timedObjectId.getInstancePk();
      return ejbTimerService.createTimerService(containerId, instancePk, invoker);
   }

   protected void sleep(long interval) throws InterruptedException
   {
      synchronized (this)
      {
         wait(interval);
      }
   }
}
