/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:TimerSerializationTestCase.java,v 1.0, 2005-06-24 19:17:58Z, Robert Worsnop$

import org.jboss.test.txtimer.test.TimedMockObject;

import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * Created by IntelliJ IDEA.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class TimerSerializationTestCase extends TimerTestBase
{
   public TimerSerializationTestCase(String name)
   {
      super(name);
   }

   public void testTimerSerialization() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);
      Timer timer = service.createTimer(500, null);
      timer.cancel();

      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);
      try
      {
         oos.writeObject(timer);
         fail("NotSerializableException expected");
      }
      catch (NotSerializableException expected)
      {
      }
   }

   public void testTimerHandleSerialization() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);
      Timer timer1 = service.createTimer(500, null);
      TimerHandle handle1 = timer1.getHandle();

      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);
      oos.writeObject(handle1);
      ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
      ObjectInputStream ois = new ObjectInputStream(bais);
      TimerHandle handle2 = (TimerHandle)ois.readObject();

      Timer timer2 = handle2.getTimer();
      assertEquals("Timers are not equal", timer1, timer2);

      sleep(1000);
      assertTrue("TimedObject not called", 1 == to.getCallCount());
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }
}
