/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:SimpleTimedObjectInvoker.java,v 1.0, 2005-06-24 19:16:25Z, Robert Worsnop$

import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.mx.util.ObjectNameFactory;

import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.management.ObjectName;
import java.util.HashMap;

/**
 * Invokes the ejbTimeout method on the TimedObject with the given id.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class SimpleTimedObjectInvoker implements TimedObjectInvoker
{
   private TimedObjectId timedObjectId;
   private HashMap objectMap = new HashMap();

   /**
    * Invokes the ejbTimeout method on the TimedObject with the given id.
    *
    * @param timer the Timer that is passed to ejbTimeout
    */
   public void callTimeout(Timer timer)
   {
      TimedObject timedObject = (TimedObject)objectMap.get(timedObjectId);
      if (timedObject == null)
         throw new NoSuchObjectLocalException("Cannot find TimedObject: " + timedObjectId);
      timedObject.ejbTimeout(timer);
   }

   public TimedObjectId addTimedObject(TimedObject timedObject)
   {
      timedObjectId = new TimedObjectId(ObjectNameFactory.create("txtimer:timedObject=" + timedObject.hashCode()));
      objectMap.put(timedObjectId, timedObject);
      return timedObjectId;
   }
}
