/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:CancelTimedMockObject.java,v 1.0, 2005-06-24 18:56:44Z, Robert Worsnop$

import javax.ejb.Timer;

import org.jboss.ejb.AllowedOperationsAssociation;

/**
 * A TimedObject that cancels the Timer upon ejbTimeout
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class CancelTimedMockObject extends TimedMockObject
{

   /**
    * Invoked upon txtimer expiration.
    */
   public void ejbTimeout(Timer timer)
   {
      AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsAssociation.IN_EJB_TIMEOUT);
      try
      {
         super.ejbTimeout(timer);
         timer.cancel();
      }
      finally
      {
         AllowedOperationsAssociation.popInMethodFlag();
      }
   }
}
