/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.txtimer.ejb;

import org.apache.log4j.Logger;
import org.jboss.test.txtimer.interfaces.TimerEntityHome;
import org.jboss.test.txtimer.interfaces.TimerEntity;
import org.jboss.test.txtimer.interfaces.TimerSessionHome;
import org.jboss.test.txtimer.interfaces.TimerSession;

import javax.ejb.*;
import javax.naming.InitialContext;
import java.rmi.RemoteException;

/**
 * Session Bean Timer Test
 *
 * @ejb.bean name="test/txtimer/TimerFacade"
 * display-name="TimerFacade Session Bean"
 * type="Stateless"
 * transaction-type="Container"
 * view-type="remote"
 * @ejb.transaction type="Required"
 */
public class TimerFacadeBean implements SessionBean
{
   private static Logger log = Logger.getLogger(TimerFacadeBean.class);

   private SessionContext context;

   /**
    * @ejb.interface-method view-type="both"
    */
   public void rollbackAfterCreateSession(long duration)
           throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      TimerSessionHome home = (TimerSessionHome) iniCtx.lookup(TimerSessionHome.JNDI_NAME);
      TimerSession bean = home.create();
      bean.createTimer(duration, 0, null);
      context.setRollbackOnly();
   }

   /**
    * @ejb.interface-method view-type="both"
    */
   public void rollbackAfterCancelSession()
           throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      TimerSessionHome home = (TimerSessionHome) iniCtx.lookup(TimerSessionHome.JNDI_NAME);
      TimerSession bean = home.create();
      bean.cancelFirstTimer();
      context.setRollbackOnly();
   }

   /**
    * @ejb.interface-method view-type="both"
    */
   public void rollbackAfterCreateEntity(long duration)
           throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      TimerEntityHome home = (TimerEntityHome) iniCtx.lookup(TimerEntityHome.JNDI_NAME);
      TimerEntity bean = home.findByPrimaryKey(new Integer(1));
      bean.createTimer(duration, 0, null);
      context.setRollbackOnly();
   }

   /**
    * @ejb.interface-method view-type="both"
    */
   public void rollbackAfterCancelEntity()
           throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      TimerEntityHome home = (TimerEntityHome) iniCtx.lookup(TimerEntityHome.JNDI_NAME);
      TimerEntity bean = home.findByPrimaryKey(new Integer(1));
      bean.cancelFirstTimer();
      context.setRollbackOnly();
   }


   // -------------------------------------------------------------------------
   // Framework Callbacks
   // -------------------------------------------------------------------------
   
   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
      this.context = ctx;
   }

   /**
    * @ejb.create-method view-type="both"
    */
   public void ejbCreate() throws CreateException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }
}
