/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txpropiiop.ejb.b;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import org.jboss.logging.Logger;
import org.jboss.test.util.Debug;

/**
 * A SessionB.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SessionBEJB implements SessionBean
{
   private static final Logger log = Logger.getLogger(SessionBEJB.class);
   
   public String sayHello(String value)
   {
      if (value.equals("Hello") == false)
         throw new EJBException("Did not get the expected 'Hello'");
      return value;
   }
   
   public String testNotSupported(String value)
   {
      return sayHello(value);
   }
   
   public String testRequired(String value)
   {
      return sayHello(value);
   }
   
   public String testSupports(String value)
   {
      return sayHello(value);
   }
   
   public String testRequiresNew(String value)
   {
      return sayHello(value);
   }
   
   public String testMandatory(String value)
   {
      return sayHello(value);
   }
   
   public String testNever(String value)
   {
      return sayHello(value);
   }
   
   public void ejbCreate() throws CreateException
   {
   }
   
   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }
   
   public void ejbRemove()
   {
   }
   
   public void setSessionContext(SessionContext ctx)
   {
   }
}
