/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.timer.ejb;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;

import org.apache.log4j.Logger;

/**
 * Stateful Session Bean Timer Test
 * @author Thomas Diesler
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 * @ejb:bean name="test/timer/TimerSFSB" display-name="Timer in Stateful Session
 * Bean" type="Stateful" transaction-type="Container" view-type="remote"
 * jndi-name="ejb/test/timer/TimerSFSB"
 * @ejb:transaction type="Required"
 */
public class TimerSFSBean
   implements SessionBean, TimedObject
{
   // -------------------------------------------------------------------------
   // Static
   // -------------------------------------------------------------------------
   private static Logger log = Logger.getLogger(TimerSFSBean.class);
   
   // -------------------------------------------------------------------------
   // Members 
   // -------------------------------------------------------------------------
   
   private SessionContext mContext;
   
   // -------------------------------------------------------------------------
   // Methods
   // -------------------------------------------------------------------------  
   
   /**
    * @ejb:interface-method view-type="both"
    */
   public void checkTimerService()
   {
      log.info("TimerSFSBean.checkTimerService(), try to get a Timer Service from the Session Context");
      mContext.getTimerService();
   }

   /**
    * Create the Session Bean
    * @ejb:create-method view-type="both"
    */
   public void ejbCreate()
   {
      log.info("TimerSFSBean.ejbCreate()");
   }

   public void ejbTimeout(Timer pTimer)
   {
      log.info("ejbTimeout(), timer: " + pTimer);
   }

   /**
    * Describes the instance and its content for debugging purpose
    * @return Debugging information about the instance and its content
    */
   public String toString()
   {
      return "TimerSFSBean [ " + " ]";
   }
   
   // -------------------------------------------------------------------------
   // Framework Callbacks
   // -------------------------------------------------------------------------
   
   public void setSessionContext(SessionContext aContext)
   {
      mContext = aContext;
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }
}
