/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.testbeancluster.interfaces;

import java.rmi.dgc.VMID;
import java.io.Serializable;

/** A data class used to track the identity of the cluster node.
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @version $Revision:1$
 */
public class NodeAnswer implements Serializable
{
   static final long serialVersionUID = 4208423567770206811L;
   public VMID nodeId = null;
   public Object answer = null;
   
   public NodeAnswer (VMID node, Object answer)
   {
      this.nodeId = node;
      this.answer = answer;
   }
   
   public VMID getNodeId ()
   {
      return this.nodeId;
   }
   
   public Object getAnswer()
   {
      return this.answer;
   }
   
   public String toString ()
   {
      return "{ " + this.nodeId + " ; " + this.answer + " }";
   }
}
