/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.security.test;

import java.security.MessageDigest;
import java.util.Map;

import org.jboss.crypto.digest.DigestCallback;

/** A test implementation of the DigestCallback which includes the digest.preSalt
 * and digest.postSalt strings into the MessageDigest
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class TestDigestCallback
   implements DigestCallback
{
   private Map options;

   public void init(Map options)
   {
      this.options = options;
      if( options.get("javax.security.auth.login.name") == null )
         throw new SecurityException("Failed to find javax.security.auth.login.name");
      if( options.get("javax.security.auth.login.password") == null )
         throw new SecurityException("Failed to find javax.security.auth.login.password");
   }


   public void preDigest(MessageDigest digest)
   {
      String salt = (String) options.get("digest.preSalt");
      digest.update(salt.getBytes());
   }

   public void postDigest(MessageDigest digest)
   {
      String salt = (String) options.get("digest.postSalt");
      digest.update(salt.getBytes());
   }
}
