/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.security.test;

import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import junit.framework.Test;
import org.jboss.security.SimplePrincipal;
import org.jboss.test.JBossTestCase;
import org.jboss.test.security.interfaces.SubjectSession;
import org.jboss.test.security.interfaces.SubjectSessionHome;


/** Tests of the caller context state
 
 @author Scott.Stark@jboss.org
 @version $Revision:1$
 */
public class CallerInfoUnitTestCase
   extends JBossTestCase
{
   public CallerInfoUnitTestCase(String name)
   {
      super(name);
   }

   /** Test return of a custom principal from getCallerPrincipal.
    */
   public void testCallerSubject() throws Exception
   {
      log.debug("+++ testCallerSubject()");
      Properties env = new Properties();
      env.setProperty(Context.INITIAL_CONTEXT_FACTORY,
         "org.jboss.security.jndi.JndiLoginInitialContextFactory");
      env.setProperty(Context.SECURITY_PRINCIPAL, "jduke");
      env.setProperty(Context.SECURITY_CREDENTIALS, "theduke");
      InitialContext ctx = new InitialContext(env);
      Object obj = ctx.lookup("caller-info.SubjectSessionFacade");
      obj = PortableRemoteObject.narrow(obj, SubjectSessionHome.class);
      SubjectSessionHome home = (SubjectSessionHome) obj;
      log.debug("Found CustomPrincipalHome");
      SubjectSession bean = home.create();
      log.debug("Created CustomPrincipal");

      HashSet principals = new HashSet();
      principals.add(new SimplePrincipal("CallerInfoFacadeRole"));
      principals.add(new SimplePrincipal("CallerInfoStatelessRole"));
      principals.add(new SimplePrincipal("CallerInfoStatefulRole"));
      principals.add(new SimplePrincipal("CallerInfoEntityRole"));
      bean.validateCallerContext("callerJduke", principals);
      bean.remove();
   }

   public static Test suite() throws Exception
   {
      return JBossTestCase.getDeploySetup(CallerInfoUnitTestCase.class, "caller-info.jar");
   }

}
