/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.interfaces;

import java.util.Set;
import java.security.GeneralSecurityException;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * A session facade interface for validating the security context 
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface SubjectSession extends EJBObject
{
   /**
    * Call a method on the ejb/StatelessSession, ejb/StatefulSession, ejb/Entity
    * ejb-refs and validate that the security context seen after each call
    * matches the expected context seen at the start of the call.
    * 
    * @param callerName - the Principal.getName expected for the getCallerPrincipal
    * @param callerPrincipals - Set<Principal> for the current Subject.getPrincipals set
    * @throws java.security.GeneralSecurityException
    */ 
   public void validateCallerContext(String callerName, Set callerPrincipals)
      throws GeneralSecurityException, RemoteException;
}
