/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.security.ejb;

import java.io.IOException;
import java.security.acl.Group;
import java.security.Principal;
import java.util.Enumeration;

import javax.security.auth.login.LoginException;

import org.jboss.security.auth.spi.UsersRolesLoginModule;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class UsersRoles2LoginModule extends UsersRolesLoginModule
{
   /**
    * Override to add '2' to every role name to make the roles different
    * @throws LoginException
    */ 
   protected Group[] getRoleSets() throws LoginException
   {
      Group[] groups = super.getRoleSets();
      Group[] newGroups = {new SimpleGroup("Roles")};
      Group roles = null;
      Group newRoles = newGroups[0];
      for(int n = 0; n < groups.length; n ++)
      {
         Group g = groups[n];
         if( g.getName().equals("Roles") )
         {
            roles = g;
            break;
         }
      }
      if( roles != null )
      {
         Enumeration iter = roles.members();
         Principal role = (Principal) iter.nextElement();
         String name2 = role.getName() + "2";
         SimplePrincipal role2 = new SimplePrincipal(name2);
         newRoles.addMember(role2);
      }
      return newGroups;
   }
}
