/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.media.format.audio.mpeg;

import java.io.File;

import javax.emb.Media;
import javax.emb.MediaBean;
import javax.emb.MediaFormatRegistry;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.media.format.audio.mpeg.MpegAudioFormat;
import org.jboss.media.format.audio.mpeg.MpegAudioHeader;
import org.jboss.media.util.ResourceUtils;

/**
 * Test case for parsing MPEG Audio headers.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ogreen@users.sourceforge.net">Owen Green</a>
 */
public class TestMpegAudioHeader extends TestCase
{
   private static final Logger log =
      Logger.getLogger(TestMpegAudioHeader.class);

   private static final String RESOURCE_DIR = "media/format/data/";
   private static final String MP3_FILE =
      "jboss96k441khz_copyright_original.mp3";
   private static final String MP3_MIME_TYPE = "audio/mpeg";

   /**
    * Constructor for TestMpegAudioHeader.
    */
   public TestMpegAudioHeader(String name)
   {
      super(name);
   }

   public void setUp() throws Exception
   {
      MediaFormatRegistry mediaFormatRegistry = MediaFormatRegistry.SINGLETON;
      mediaFormatRegistry.bind("mp3", new MpegAudioFormat());
   }

   public void tearDown() throws Exception
   {
      MediaFormatRegistry mediaFormatRegistry = MediaFormatRegistry.SINGLETON;
      mediaFormatRegistry.unbind("mp3");
   }

   public void testGetHeader() throws Exception
   {
      File file = ResourceUtils.getResourceFile(RESOURCE_DIR + MP3_FILE);
      Media media = new MediaBean(file, MP3_MIME_TYPE);
      MpegAudioHeader header = (MpegAudioHeader) media.getHeader();

      String[] fieldNames = header.getFieldNames();

      if (log.isDebugEnabled())
      {
         for (int i = 0; i < fieldNames.length; i++)
         {
            System.out.println(
               fieldNames[i] + ": " + header.getField(fieldNames[i]));
         }
      }

      assertEquals("Original", true, header.isOriginal());
      assertEquals("Copyright", true, header.isCopyright());
      assertEquals("Bit Rate", 96, header.getBitrate());
      assertEquals("Sample Rate", 44100, header.getSamplerate());
      assertEquals(
         "ChannelMode",
         MpegAudioFormat.ChannelMode.JOINT_STEREO,
         header.getChannelMode());
      assertEquals(
         "Version",
         MpegAudioFormat.Version.MPEG1,
         header.getVersion());
      assertEquals("Layer", MpegAudioFormat.Layer.LAYERIII, header.getLayer());
   }
}