/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jrmp.test;

import java.io.IOException;
import java.rmi.RemoteException;
import java.net.URL;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jboss.test.JBossTestCase;

import org.jboss.test.jrmp.interfaces.StatelessSession;
import org.jboss.test.jrmp.interfaces.StatelessSessionHome;

/**
 * Test of using custom RMI socket factories with the JRMP ejb container
 * invoker.
 *
 * @author  Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SSLSocketsUnitTestCase extends JBossTestCase
{
   /**
    * Constructor for the CustomSocketsUnitTestCase object
    *
    * @param name  Description of Parameter
    */
   public SSLSocketsUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * Test basic ejb access over the ssl socket requiring a client cert
    *
    * @exception Exception  Description of Exception
    */
   public void testClientCertSSLAccess() throws Exception
   {
      log.info("+++ testClientCertSSLAccess");
      // Install the truststore to use for the server cert
      String res = super.getResourceURL("test-configs/tomcat-ssl/conf/ca.keystore");
      log.info("ca.keystore: "+res);
      URL keystoreURL = new URL(res);
      res = super.getResourceURL("test-configs/tomcat-ssl/conf/client.keystore");
      log.info("client.keystore: "+res);
      URL clientURL = new URL(res);
      System.setProperty("javax.net.ssl.trustStore", clientURL.getFile());
      System.setProperty("javax.net.ssl.trustStorePassword", "unit-tests-client");
      System.setProperty("javax.net.ssl.keyStore", clientURL.getFile());
      System.setProperty("javax.net.ssl.keyStorePassword", "unit-tests-client");

      InitialContext jndiContext = new InitialContext();
      log.debug("Lookup StatelessSessionWithSSL");
      Object obj = jndiContext.lookup("StatelessSessionWithSSL");
      StatelessSessionHome home = (StatelessSessionHome)obj;
      log.debug("Found StatelessSessionWithSSL Home");
      StatelessSession bean = home.create();
      log.debug("Created StatelessSessionWithSSL");
      // Test that the Entity bean sees username as its principal
      String echo = bean.echo("jrmp");
      log.debug("bean.echo(jrmp) = " + echo);
      bean.remove();
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(SSLSocketsUnitTestCase.class, "jrmp-comp.jar");
   }

}
