/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jrmp.test;

import java.io.IOException;
import java.rmi.RemoteException;
import java.net.URL;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jboss.test.JBossTestCase;

import org.jboss.test.jrmp.interfaces.StatelessSession;
import org.jboss.test.jrmp.interfaces.StatelessSessionHome;

/**
 * Test of using custom RMI socket factories with the JRMP ejb container
 * invoker.
 *
 * @author  Scott.Stark@jboss.org
 * @author  david jencks d_jencks@users.sourceforge.net
 * @version $Revision:1$
 */
public class CustomSocketsUnitTestCase extends JBossTestCase
{
   /**
    * Constructor for the CustomSocketsUnitTestCase object
    *
    * @param name  Description of Parameter
    */
   public CustomSocketsUnitTestCase(String name)
   {
      super(name);
   }


   /**
    * Test access of a custom type over the compressed socket
    *
    * @exception Exception  Description of Exception
    */
   public void testCustomAccess() throws Exception
   {
      log.info("+++ testCustomAccess");
      InitialContext jndiContext = new InitialContext();
      log.debug("Lookup StatelessSessionWithGZip");
      Object obj = jndiContext.lookup("StatelessSessionWithGZip");
      StatelessSessionHome home = (StatelessSessionHome)obj;
      log.debug("Found StatelessSessionWithGZip Home");
      StatelessSession bean = home.create();
      log.debug("Created StatelessSessionWithGZip");
      // Test that the Entity bean sees username as its principal
      String echo = bean.echo("jrmp-comp");
      log.debug("bean.echo(jrmp-comp) = " + echo);
      bean.remove();
   }

   /**
    * Test basic ejb access over the compressed socket
    *
    * @exception Exception  Description of Exception
    */
   public void testAccess() throws Exception
   {
      log.info("+++ testAccess");
      InitialContext jndiContext = new InitialContext();
      log.debug("Lookup StatelessSessionWithGZip");
      Object obj = jndiContext.lookup("StatelessSessionWithGZip");
      StatelessSessionHome home = (StatelessSessionHome)obj;
      log.debug("Found StatelessSessionWithGZip Home");
      StatelessSession bean = home.create();
      log.debug("Created StatelessSessionWithGZip");
      // Test that the Entity bean sees username as its principal
      String echo = bean.echo("jrmp");
      log.debug("bean.echo(jrmp) = " + echo);
      bean.remove();
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(CustomSocketsUnitTestCase.class, "jrmp-comp.jar");
   }

}
