/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.jmx.test;

import java.net.URL;
import java.net.HttpURLConnection;

import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.HttpClient;

import org.jboss.test.JBossTestCase;
import org.jboss.test.util.web.HttpUtils;

/** Basic access tests of the http jmx-console interface
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JMXConsoleUnitTestCase
   extends JBossTestCase
{
   private String baseURLNoAuth = HttpUtils.getBaseURLNoAuth(); 

   public JMXConsoleUnitTestCase(String name)
   {
      super(name);
   }

   /** Test access of the jmx-console/index.jsp page
    * @throws Exception
    */ 
   public void testIndexPage()
      throws Exception
   {
      URL url = new URL(baseURLNoAuth+"jmx-console/index.jsp");
      HttpUtils.accessURL(url);
   }

   /** Test an mbean inspection via a get to the HtmlAdaptor
    * @throws Exception
    */ 
   public void testMBeanInspection()
      throws Exception
   {
      // The jboss:service=Naming mbean view 
      URL url = new URL(baseURLNoAuth+"jmx-console/HtmlAdaptor?action=inspectMBean&name=jboss%3Aservice%3DNaming");
      HttpUtils.accessURL(url);
   }

   /** Test an mbean invocation via a post to the HtmlAdaptor
    * @throws Exception
    */ 
   public void testMBeanOperation()
      throws Exception
   {
      // The jboss.system:type=Server mbean view 
      URL url = new URL(baseURLNoAuth+"jmx-console/HtmlAdaptor?action=inspectMBean&name=jboss.system%3Atype%3DServer");
      HttpUtils.accessURL(url);
      // Submit the op invocation form for op=runGarbageCollector
      PostMethod formPost = new PostMethod(baseURLNoAuth+"jmx-console/HtmlAdaptor");
      formPost.addRequestHeader("Referer", baseURLNoAuth+"jmx-console/HtmlAdaptor");
      formPost.addParameter("action", "invokeOpByName");
      formPost.addParameter("name", "jboss.system:type=Server");
      formPost.addParameter("methodName", "runGarbageCollector");
      HttpClient httpConn = new HttpClient();
      int responseCode = httpConn.executeMethod(formPost.getHostConfiguration(),
         formPost);
      assertTrue("HTTP_OK", responseCode==HttpURLConnection.HTTP_OK);
   }
}
