/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jmx.invoker;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.management.Notification;
import org.jboss.jmx.adaptor.rmi.RMINotificationListener;
import org.jboss.net.sockets.TimeoutClientSocketFactory;

/** An RMI callback implementation used to receive remote JMX notifications
 * that blocks in the handleNotification callback to validate that poorly
 * behaving clients do not affect the server side service sending the
 * nofication.
 *  
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class BadListener implements RMINotificationListener
{
   int count;

   public int getCount()
   {
      return count;
   }
   public void export() throws RemoteException
   {
      TimeoutClientSocketFactory tcsf = new TimeoutClientSocketFactory();
      UnicastRemoteObject.exportObject(this, 0, tcsf, null);
   }
   public void unexport() throws RemoteException
   {
      UnicastRemoteObject.unexportObject(this, true);
   }
   public void handleNotification(Notification event, Object handback)
   {
      System.out.println("BadListener handleNotification, event: "+event+", count="+count);
      count ++;
      try
      {
         System.out.println("Sleeping 30 seconds...");
         Thread.sleep(30*1000);
      }
      catch(InterruptedException e)
      {
         e.printStackTrace();
      }
      System.out.println("Awake");
   }
}
