/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jmsra.bean;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;

import org.jboss.test.util.ejb.EntitySupport;

/**
 * 3rdparty bean to help test JMS RA transactions.
 *
 * <p>Created: Tue Apr 24 22:32:41 2001
 *
 * @author  <a href="mailto:peter.antman@tim.se">Peter Antman</a>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @version $Revision:1$
 */
public class PublisherCMPBean
    extends EntitySupport
{
    public Integer nr;
    
    public PublisherCMPBean() {
        // empty
    }
    
    public Integer getNr() {
        return nr;
    }

    public void setNr(Integer nr) {
        this.nr = nr;
    }

    public void ok(int nr) {
        // Do nothing
    }

    public void error(int nr) {
        // Roll back throug an exception
        throw new EJBException("Roll back!");
    }
    
    // EntityBean implementation -------------------------------------
    
    public Integer ejbCreate(Integer nr)
        throws CreateException
    {
        this.nr = nr;
        return null;
    }

    public void ejbPostCreate(Integer nr)
        throws CreateException
    {
    }

    public void ejbLoad()
    {
    }
    
} // PublisherCMPBean
