/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.jca.securedejb;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface CallerIdentity extends EJBObject
{
   /**
    * Access a DataSource that uses the method caller as the identity for
    * creating a connection.
    * The caller must have the UseCallerForAuth and CallerIdentityUser roles.
    * @throws RemoteException
    */ 
   public void useCallerForAuth() throws RemoteException;

   /**
    * Access a DataSource that uses the method caller as the identity for
    * creating a connection.
    * The caller must have the UseConfiguredForAuth and CallerIdentityUser roles.
    * @throws RemoteException
    */ 
   public void useConfiguredForAuth() throws RemoteException;

   public void useRunAsForAuthDS() throws RemoteException;
   public void useRunAsForAuthFS() throws RemoteException;
}
