/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.inflow;

import java.util.Timer;
import java.util.TimerTask;

import javax.resource.spi.endpoint.MessageEndpoint;

/**
 * Management interface of TestResourceAdapter.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class TestResourceAdapterTimer
{
   TestResourceAdapter adapter;
   public TestResourceAdapterTimer(TestResourceAdapter adapter)
   {
      this.adapter = adapter;
   }
   
   public TestResourceAdapterTimerResults run() throws Exception
   {
      TestResourceAdapterTimerResults results = new TestResourceAdapterTimerResults();
      try
      {
         basicTest();
         results.basicTest.pass();
      }
      catch (Throwable t)
      {
         results.basicTest.fail(t);
      }

      return results;
   }
   
   public void basicTest() throws Exception
   {
      Timer timer = adapter.ctx.createTimer();
      TestTimerTask task = new TestTimerTask();
      timer.schedule(task, 5000l);
      Thread.sleep(10000);
      if (task.complete == false)
         throw new Exception("Task was not run");
   }
   
   public class TestTimerTask extends TimerTask
   {
      public boolean complete = false;
      
      public void run()
      {
         complete = true;
      }
}
}
