/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.jca.fs;

import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.work.WorkManager;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

import org.jboss.logging.Logger;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

/** The ResourceAdapter for the file system based DirContext
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class FSDirContextAdaptor implements ResourceAdapter
{
   private static final Logger log = Logger.getLogger(FSDirContextAdaptor.class);
   
   private BootstrapContext ctx;
   /** The activations by activation spec */
   private ConcurrentReaderHashMap activations = new ConcurrentReaderHashMap();

   /**
    * Get the work manager
    * 
    * @return the work manager
    */
   public WorkManager getWorkManager()
   {
      return ctx.getWorkManager();
   }

   // --- Begin ResourceAdapter interface methods
   public void start(BootstrapContext ctx)
      throws ResourceAdapterInternalException
   {
      log.debug("start");
      this.ctx = ctx;
      WorkManager mgr = ctx.getWorkManager();
   }

   public void stop()
   {
      log.debug("stop");
   }

   public void endpointActivation(MessageEndpointFactory endpointFactory,
      ActivationSpec spec)
      throws ResourceException
   {
      log.debug("endpointActivation, spec="+spec);
      FSActivationSpec fsSpec = (FSActivationSpec) spec;
      FSActivation activation = new FSActivation(this, endpointFactory,
         fsSpec);
      activations.put(spec, activation);
   }

   public void endpointDeactivation(MessageEndpointFactory endpointFactory,
      ActivationSpec spec)
   {
      log.debug("endpointDeactivation, spec="+spec);
      FSActivation activation = (FSActivation) activations.remove(spec);
   }

   public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException
   {
      return new XAResource[0];
   }
   // --- End ResourceAdapter interface methods
}
