/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jca.ejb;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.ejb.CreateException;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.apache.log4j.Category;
import javax.transaction.UserTransaction;
import javax.ejb.EJBException;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;


import org.jboss.test.jca.adapter.TestConnectionFactory;
import org.jboss.test.jca.adapter.TestConnection;


/**
 * RollbackOnlyReleaseConnectionSessionBean.java
 *
 *
 * Created: 20-Oct-2004
 *
 * @author <a href="mailto:noel.rocher@jboss.org">Noel Rocher</a>
 * @ejb.bean name="RollbackOnlyReleaseConnectionSession"
 *           display-name="Name for RollbackOnlyReleaseConnectionSession"
 *           description="Description for RollbackOnlyReleaseConnectionSession"
 *           jndi-name="RollbackOnlyReleaseConnectionSession"
 *           type="Stateless"
 *           view-type="remote"
 * 			 transaction-type = "Container"
 * @ejb.transaction type = "Required" 
 *
 *  */
public class RollbackOnlyReleaseConnectionSessionBean implements SessionBean {

	  private SessionContext	bean_context;
	   private Category log = Category.getInstance(getClass().getName());




	public void ejbCreate()  throws CreateException
	    {
	    }
	/**
	 * 
	 */
	public RollbackOnlyReleaseConnectionSessionBean() {super();}


	/**
	 * @ejb.interface-method view-type = "both" 
	 * @param in_name
	 */
	public boolean testConnectionRelease() throws java.rmi.RemoteException
	{
		Connection conn = null;
		long pre_connection_number=0;
		long post_connection_number=0;
		boolean result=false;
		try {
			// set Transaction to Rollback Only
			this.bean_context.setRollbackOnly();

			Thread.sleep(500); // simulate some processing

			javax.sql.DataSource ds =  (javax.sql.DataSource)(new InitialContext()).lookup("java:DefaultDS");
			pre_connection_number = getConnectionInUseNumber();
			conn = ds.getConnection();
			conn.createStatement().execute("select 1");
			conn.close();
			
		} catch (org.jboss.util.NestedSQLException ignore) {// this is the expected exception}
		} catch (Exception e) {
	         e.printStackTrace();
	         throw new EJBException("unexpected exception: " + e);
		}
		finally {
			try {
				conn.close();
			} catch (Exception ignore) {}
		}


		// compare in use connection numbers
		try {
			post_connection_number = getConnectionInUseNumber();
			log.debug("Pre # = " + pre_connection_number + " ; Post #" + post_connection_number);
			if (pre_connection_number == post_connection_number)
				{
				log.debug("Test is OK ");
				 result = true;
				}
			else
				{
				log.debug("Test is *NOT* OK ");
				 result = false;
				}
		} catch (Exception e) {
	         e.printStackTrace();
	         throw new EJBException("unexpected exception: " + e);
		}
	
		return result;

	}
	
	
	
	private long getConnectionInUseNumber() throws Exception
	{
	long result=0;
	result = ((Long)((RMIAdaptor)(new InitialContext()).lookup("jmx/invoker/RMIAdaptor")).getAttribute(new ObjectName("jboss.jca:name=DefaultDS,service=ManagedConnectionPool"), "InUseConnectionCount")).longValue();
	return result;
	}


	public void ejbActivate() throws EJBException, RemoteException {}
	public void ejbPassivate() throws EJBException, RemoteException {}
	public void ejbRemove() throws EJBException, RemoteException {}

	public void setSessionContext(SessionContext ctx)
		throws EJBException,
		RemoteException {

        bean_context=ctx;
	}

}// RollbackOnlyReleaseConnectionSessionBean
