/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.test.jbossnet.state.server;

import org.jboss.test.util.ejb.SessionSupport;

/**
 * Stateful web service to test default message scoping for stateful beans.
 * @author jung
 * @version $Revision:1$
 * @ejb.bean name="State"
 *           display-name="State Count Bean"
 *           type="Stateful"
 *           view-type="remote"
 *           jndi-name="state/State"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.state.State" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.state.StateHome" extends="javax.ejb.EJBHome"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="State"
 */

public class StateBean
   extends SessionSupport implements javax.ejb.SessionBean
{
   protected int count=0;

   /** restore count upon pooling */
   public void ejbCreate() {
   	count=0;
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */
   
   public int count() 
   {
      return count++;
   }
}
