/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:SecurityUnitTestCase.java,v 1.0, 2005-06-24 19:15:43Z, Robert Worsnop$

package org.jboss.test.jbossnet.security;

import junit.framework.Test;
import org.jboss.test.jbossnet.JBossNetTestBase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import java.net.URL;

/**
 * Tests security issues of web services
 * @since 5. Oktober 2001, 12:11
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */
public class SecurityUnitTestCase extends JBossNetTestBase
{
   private QName AUTHENTICATION_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/Authentication", "AuthenticationService");
   private QName AUTHORIZATION_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/Authorization", "AuthorizationService");

   // Constructors --------------------------------------------------
   public SecurityUnitTestCase(String name)
   {
      super(name);
   }

   /** the session bean with which we interact */
   Authentication jduke_authentication;
   Authentication jdukeman_authentication;
   Authorization jduke_authorization;
   Authorization jdukeman_authorization;
   Authorization not_authorized;
   Authentication not_authenticated;

   /** setup the bean */
   public void setUp() throws Exception
   {
      super.setUp();
      URL wsdlAuthentication = new URL(SERVICES_LOCATION + "/Authentication?wsdl");
      URL wsdlAuthorization = new URL(SERVICES_LOCATION + "/Authorization?wsdl");

      jduke_authentication = (Authentication)createService(wsdlAuthentication, AUTHENTICATION_SERVICE).getPort(Authentication.class);
      ((Stub)jduke_authentication)._setProperty(Stub.USERNAME_PROPERTY, "jduke");
      ((Stub)jduke_authentication)._setProperty(Stub.PASSWORD_PROPERTY, "theduke");

      jduke_authorization = (Authorization)createService(wsdlAuthorization, AUTHORIZATION_SERVICE).getPort(Authorization.class);
      ((Stub)jduke_authorization)._setProperty(Stub.USERNAME_PROPERTY, "jduke");
      ((Stub)jduke_authorization)._setProperty(Stub.PASSWORD_PROPERTY, "theduke");

      jdukeman_authentication = (Authentication)createService(wsdlAuthentication, AUTHENTICATION_SERVICE).getPort(Authentication.class);
      ((Stub)jdukeman_authentication)._setProperty(Stub.USERNAME_PROPERTY, "jdukeman");
      ((Stub)jdukeman_authentication)._setProperty(Stub.PASSWORD_PROPERTY, "anotherduke");

      jdukeman_authorization = (Authorization)createService(wsdlAuthorization, AUTHORIZATION_SERVICE).getPort(Authorization.class);
      ((Stub)jdukeman_authorization)._setProperty(Stub.USERNAME_PROPERTY, "jdukeman");
      ((Stub)jdukeman_authorization)._setProperty(Stub.PASSWORD_PROPERTY, "anotherduke");

      not_authenticated = (Authentication)(Authentication)createService(wsdlAuthentication, AUTHENTICATION_SERVICE).getPort(Authentication.class);
      not_authorized = (Authorization)createService(wsdlAuthorization, AUTHORIZATION_SERVICE).getPort(Authorization.class);
   }

   /** test authentication effects */
   public void testAuthentication() throws Exception
   {
      assertTrue("Correctly authenticated as role1, role2", jduke_authentication.workedOut());
      assertTrue("Correctly authenticated as role3, role2", !jdukeman_authentication.workedOut());
      try
      {
         not_authenticated.workedOut();
         fail("Not authenticated user came through.");
      }
      catch (Exception e)
      {
      }
   }

   /** test authorization effects */
   public void testAuthorization() throws Exception
   {
      assertTrue("Correctly authorized.", jduke_authorization.workedOut());
      try
      {
         jdukeman_authorization.workedOut();
         fail("Wrong authorization came through");
      }
      catch (Exception e)
      {
      }
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(SecurityUnitTestCase.class, "jbossnet-security.ear");
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(SecurityUnitTestCase.class);
   }

}