/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jbossnet.ejbsimple.server;

import javax.ejb.EJBException;

import org.jboss.test.util.ejb.SessionSupport;

import org.jboss.test.jbossnet.ejbsimple.HelloData;
import org.w3c.dom.Element;

/**
 * The typical Hello Session Bean this time
 * as a web-service.
 * @author jung
 * @version $Revision:1$
 * @ejb.bean name="HelloLocal"
 *           display-name="Hello World Bean Local"
 *           type="Stateless"
 *           view-type="local"
 *           local-jndi-name="hello/HelloLocal"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="HelloLocal"
 * @ejb.interface local-class="org.jboss.test.jbossnet.ejbsimple.server.HelloLocal" local-extends="javax.ejb.EJBLocalObject"
 * @ejb.home local-class="org.jboss.test.jbossnet.ejbsimple.server.HelloLocalHome" local-extends="javax.ejb.EJBLocalHome"
 */

public class HelloLocalBean
   extends SessionSupport
   implements javax.ejb.SessionBean {
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="local"
    */

   public String hello(String name) {
      return "Hello " + name + "!";
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="local"
    */

   public String howdy(HelloData name) {
      return "Howdy " + name.getName() + "!";
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="local"
    */

   public void throwException() {
      throw new EJBException("Something went wrong");
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="local"
    */
   public Object[] arrays(Object[] values) {
      return values;
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="local"
    */
   public Object[] reverse(Object[] values) {
      Object[] result = new Object[values.length];
      for (int i = 0; i < values.length; ++i)
         result[i] = values[values.length - i - 1];
      return result;
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="local"
    */
   public HelloData[] typedArrays(HelloData[] values) {
      return values;
   }
   
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="local"
    */

   public Element element(Element in) {
      return in;
   }
}
