/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jbossmx.implementation.util;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.test.jbossmx.implementation.TestCase;
import org.jboss.test.jbossmx.implementation.util.support.Trivial;
import org.jboss.test.jbossmx.implementation.util.support.TrivialMBean;

/**
 * @author <a href="dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision:1$
 */
public class MBeanProxyExtTestCase
   extends TestCase
{
   public MBeanProxyExtTestCase(String s)
   {
      super(s);
   }

   public void testObjectEqualsOnProxy()
      throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();
      ObjectName oname   = new ObjectName("test:name=trivial");

      server.registerMBean(new Trivial(), oname);
      
      TrivialMBean mbean = (TrivialMBean)MBeanProxyExt.create(
            TrivialMBean.class, oname, server
      );
      
      assertTrue(mbean.equals(mbean));
   }
}
