/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossmq.test;

import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;

import org.jboss.test.JBossTestCase;

/**
 * Duplciate client id tests
 *
 * @author <a href="mailto:adrian@jboss.org>Adrian Brock</a>
 * @version <tt>$Revision:1$</tt>
 */
public class DuplicateClientIDUnitTestCase extends JBossTestCase
{
   static String TOPIC_FACTORY = "ConnectionFactory";
   
   public DuplicateClientIDUnitTestCase(String name) throws Exception
   {
      super(name);
   }

   public void testDuplicateClientID() throws Exception
   {
      TopicConnection c1 = getTopicConnectionFactory().createTopicConnection();
      try
      {
         c1.setClientID("testClientID");
         TopicConnection c2 = getTopicConnectionFactory().createTopicConnection();
         try
         {
            c2.setClientID("testClientID");
            fail("Should not be here - duplicate client id");
         }
         catch (InvalidClientIDException expected)
         {
         }
         finally
         {
            c2.close();
         }
      }
      finally
      {
         c1.close();
      }
   }

   public void testPreconfiguredDuplicateClientID() throws Exception
   {
      TopicConnection c1 = getTopicConnectionFactory().createTopicConnection("john", "needle");
      try
      {
         try
         {
            TopicConnection c2 = getTopicConnectionFactory().createTopicConnection("john", "needle");
            c2.close();
            fail("Should not be here - duplicate client id");
         }
         catch (JMSException expected)
         {
         }
      }
      finally
      {
         c1.close();
      }
   }

   public void testNotDuplicateClientID() throws Exception
   {
      TopicConnection c1 = getTopicConnectionFactory().createTopicConnection();
      try
      {
         TopicConnection c2 = getTopicConnectionFactory().createTopicConnection();
         c2.close();
      }
      finally
      {
         c1.close();
      }
   }

   protected TopicConnectionFactory getTopicConnectionFactory() throws Exception
   {
      Context context = getInitialContext();
      return (TopicConnectionFactory) context.lookup(TOPIC_FACTORY);
   }
}

