/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jaxr.scout.util;

import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Key;

/** A Utility class that is used by the JAXR Testsuite
 *  @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 *  @since  Mar 9, 2005
 */
public class ScoutUtil
{
   public static void validateAssociation(Association a, String sourceOrgName)
           throws Exception
   {
      Organization o = (Organization)a.getSourceObject();
      if(o.getName() == null || o.getName().getValue() == null)
        throw new Exception("Source OrgName in association is null");
      if (!o.getName().getValue().equals(sourceOrgName))
      {
         throw new Exception("Invalid Source Org in Association");
      }
      o = (Organization)a.getTargetObject();
      if(o.getName()== null || o.getName().getValue() == null)
         throw new Exception("Target OrgName in association is null");;
      Concept atype = a.getAssociationType();
      if(atype.getName() == null || atype.getName().getValue() ==null)
       throw new Exception("Concept stored in Association" );
   }
}
