/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.jaxr.scout.publish;


import org.jboss.test.jaxr.scout.JaxrBaseTestCase;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.JAXRResponse;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/** Tests Jaxr Save Organization
 *  @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 *  @since  Dec 29, 2004
 */

public class JaxrSaveOrganizationTestCase extends JaxrBaseTestCase
{
   public void testSaveOrg() throws JAXRException
   {
      String keyid = "";
      login();
      try
      {
         RegistryService rs = connection.getRegistryService();

         blm = rs.getBusinessLifeCycleManager();
         Collection orgs = new ArrayList();
         Organization org = createOrganization("JBOSS");

         orgs.add(org);
         BulkResponse br = blm.saveOrganizations(orgs);
         if (br.getStatus() == JAXRResponse.STATUS_SUCCESS)
         {
            System.out.println("Organization Saved");
            Collection coll = br.getCollection();
            Iterator iter = coll.iterator();
            while (iter.hasNext())
            {
               Key key = (Key)iter.next();
               keyid = key.getId();
               System.out.println("Saved Key=" + key.getId());
               assertNotNull(keyid);
            }//end while
         }
         else
         {
            System.err.println("JAXRExceptions " +
                    "occurred during save:");
            Collection exceptions = br.getExceptions();
            Iterator iter = exceptions.iterator();
            while (iter.hasNext())
            {
               Exception e = (Exception)iter.next();
               System.err.println(e.toString());
               fail(e.toString());
            }
         }
      }
      catch (JAXRException e)
      {
         e.printStackTrace();
         fail(e.getMessage());
      }
      checkBusinessExists(keyid);
   }

   private void checkBusinessExists(String keyid)
   {
      //TODO:Given a key of a business, query it

   }


}