/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jaxr.scout.basic;

import junit.framework.TestCase;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.registry.ConnectionFactory;
import java.util.Properties;

/**
 * Tests the JAXR connection factory bound
 * to JNDI
 *
 * @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 * @since Apr 12, 2005
 */
public class JaxrJNDIConnectionTestCase extends TestCase
{
    public JaxrJNDIConnectionTestCase(String name)
    {
        super(name);
    }

    public void testJaxrJNDIConnection() throws Exception
    {
        String bindname = System.getProperty("jndi.bind.name");
        InitialContext ctx = getClientContext();
        ConnectionFactory factory = (ConnectionFactory) ctx.lookup(bindname);
        assertNotNull("Connection Factory from JNDI:", factory);
    }

    protected InitialContext getClientContext() throws NamingException
    {
        String hostname = System.getProperty("host.name");
        Properties env = new Properties();
        env.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
        env.setProperty(Context.URL_PKG_PREFIXES, "org.jboss.naming:org.jnp.interfaces");
        env.setProperty(Context.PROVIDER_URL, "jnp://" + hostname + ":1099");
        return new InitialContext(env);
    }
}
