/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jacc.test;

import javax.security.auth.login.Configuration;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.extensions.TestSetup;
import org.jboss.test.JBossTestSetup;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

/** Test of EJB spec conformace using the security-spec.jar
 deployment unit when running under a JACC authorization manager.

@author Scott.Stark@jboss.org
@version $Revision:1$
 */
public class EJBSpecUnitTestCase
   extends org.jboss.test.security.test.EJBSpecUnitTestCase
{

   public EJBSpecUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * @todo this fails under JACC because there is no automatic granting
    * of the correct create permissions needed for the handle activation. This
    * is due to the implementation detail of the handle calling back into
    * the container on activation.
    */ 
   public void testStatefulHandle()
   {
      
   }

   /**
    * Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(EJBSpecUnitTestCase.class));

      // Create an initializer for the test suite
      TestSetup wrapper = new JBossTestSetup(suite)
      {
         protected void setUp() throws Exception
         {
            super.setUp();
            Configuration.setConfiguration(new XMLLoginConfigImpl());
            redeploy("security-spec.jar");
            flushAuthCache();
         }
         protected void tearDown() throws Exception
         {
            undeploy("security-spec.jar");
            super.tearDown();
         
         }
      };
      return wrapper;
   }

}
