/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.isolation.test;

import javax.management.Attribute;
import javax.management.AttributeList;

import org.jboss.deployment.EARDeployerMBean;
import org.jboss.test.JBossTestCase;
import org.jboss.test.isolation.interfaces.a.SessionA;
import org.jboss.test.isolation.interfaces.a.SessionAHome;

/**
 * A IsolationUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class IsolationUnitTestCase extends JBossTestCase
{
   public IsolationUnitTestCase(String name)
   {
      super(name);
   }
   
   public void testIsolation() throws Exception
   {
      isolateDeployments(Boolean.TRUE);
      try
      {
         deploy("isolationA.ear");
         try
         {
            // Run the test
            deploy("isolationB.ear");
            try
            {
               doTest();
            }
            finally
            {
               undeploy("isolationB.ear");
            }

            // Run the test after a redeployment
            deploy("isolationB.ear");
            try
            {
               doTest();
            }
            finally
            {
               undeploy("isolationB.ear");
            }
         }
         finally
         {
            undeploy("isolationA.ear");
         }
      }
      finally
      {
         isolateDeployments(Boolean.FALSE);
      }
   }
   
   private void doTest() throws Exception
   {
      SessionAHome home = (SessionAHome) getInitialContext().lookup("SessionA");
      SessionA session = home.create();
      session.invokeSessionB();
   }
   
   private void isolateDeployments(Boolean value) throws Exception
   {
      getServer().setAttribute(EARDeployerMBean.OBJECT_NAME, new Attribute("Isolated", value));
      getServer().setAttribute(EARDeployerMBean.OBJECT_NAME, new Attribute("CallByValue", value));
   }
}
