/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
//$Id:UserRole.java,v 1.0, 2005-06-24 19:18:42Z, Robert Worsnop$
package org.jboss.test.hibernate.model;

import java.io.Serializable;
import java.util.Calendar;

/**
 * Association class for the many-to-many assocition from User to Role.
 * @author Gavin King
 */
public class UserRole implements Serializable
{
   static final long serialVersionUID = -1953830525461941982L;
   private User user;
   private Role role;
   private Calendar timeOfCreation;

   private UserRole()
   {
   }

   public UserRole(User user, Role role)
   {
      this.user = user;
      this.role = role;
      this.timeOfCreation = Calendar.getInstance();
   }

   public Role getRole()
   {
      return role;
   }

   public void setRole(Role role)
   {
      this.role = role;
   }

   public Calendar getTimeOfCreation()
   {
      return timeOfCreation;
   }

   public void setTimeOfCreation(Calendar timeOfCreation)
   {
      this.timeOfCreation = timeOfCreation;
   }

   public User getUser()
   {
      return user;
   }

   public void setUser(User user)
   {
      this.user = user;
   }

}

