/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.hibernate.ejb.interfaces;

/**
 * Utility class for ProfileService.
 */
public class AggregateProfileServiceUtil
{

   private static Object lookupHome(java.util.Hashtable environment, String jndiName, Class narrowTo) throws javax.naming.NamingException {
      // Obtain initial context
      javax.naming.InitialContext initialContext = new javax.naming.InitialContext(environment);
      try {
         Object objRef = initialContext.lookup(jndiName);
         // only narrow if necessary
         if (narrowTo.isInstance(java.rmi.Remote.class))
            return javax.rmi.PortableRemoteObject.narrow(objRef, narrowTo);
         else
            return objRef;
      } finally {
         initialContext.close();
      }
   }

   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for ProfileService. Lookup using JNDI_NAME
    */
   public static AggregateProfileServiceHome getHome() throws javax.naming.NamingException
   {
         return (AggregateProfileServiceHome) lookupHome(null, AggregateProfileServiceHome.JNDI_NAME, AggregateProfileServiceHome.class);
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for ProfileService. Lookup using JNDI_NAME
    */
   public static AggregateProfileServiceHome getHome( java.util.Hashtable environment ) throws javax.naming.NamingException
   {
       return (AggregateProfileServiceHome) lookupHome(environment, AggregateProfileServiceHome.JNDI_NAME, AggregateProfileServiceHome.class);
   }

}