/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.ha.singleton;

import java.security.InvalidParameterException;
import java.util.Stack;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import org.jboss.ha.singleton.HASingletonController;

/**
 * 
 * @author  Ivelin Ivanov <ivelin@jboss.org>
 *
 */
public class HASingletonControllerTester extends HASingletonController
{

  public Stack __invokationStack__ = new Stack();

  protected Object invokeSingletonMBeanMethod(ObjectName name,
     String operationName, Object param)
     throws InstanceNotFoundException, MBeanException, ReflectionException
  {
    __invokationStack__.push("invokeMBeanMethod:" + name.getCanonicalName() + "." + operationName);
    return null;
  }

}
