/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cts.keys;

import java.io.Serializable;

/**
 * Class AccountPK
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class AccountPK
   implements Serializable
{
   static final long serialVersionUID = -8235667863328981860L;
   public String key;

   /**
    * Constructor AccountPK
    *
    *
    * @param key
    *
    */
   public AccountPK (String key)
   {
      this.key = key;
   }

   public String getKey ()
   {
      return this.key;
   }
   public void setKey(String key)
   {
      this.key = key;
   }

   /**
    * Method equals
    *
    *
    * @return
    *
    */
   public boolean equals( Object obj )
   { 
       Class cl = obj.getClass( );
       AccountPK pk = (AccountPK)obj;
       return ( (cl.isInstance(this)) && (this.key.trim().compareTo(pk.getKey().trim()) == 0) );
   }

   public String toString()
   {
      return key;
   }

   public int hashCode()
   {
      return key.hashCode();
   }
}
