/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.test.cts.ejb;

import java.rmi.RemoteException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;


import org.jboss.test.cts.keys.AccountPK;
import org.jboss.logging.Logger;

/**
 * A simple cmp2 entity bean implementation
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public abstract class CtsCmpBean
   implements EntityBean
{
   static Logger log = Logger.getLogger(CtsCmpBean.class);
   private EntityContext ctx = null;

   public AccountPK ejbCreate(AccountPK pk, String personsName)
      throws CreateException, DuplicateKeyException
   {
      log.debug("entry ejbCreate, pk=" + pk);
      setPk(pk);
      setPersonsName(personsName);
      return null;
   }

   public void ejbPostCreate(AccountPK pk, String personsName)
      throws CreateException, DuplicateKeyException, EJBException,
      RemoteException
   {
      log.debug("entry ejbPostCreate, pk=" + pk);
   }

   public void ejbLoad()
      throws EJBException, RemoteException
   {
      log.debug("ejbLoad () called");

   }

   public void ejbStore()
      throws EJBException, RemoteException
   {
      log.debug("ejbStore () called");

   }

   public void ejbRemove()
      throws EJBException, RemoteException
   {
      log.debug("ejbRemove () called");

   }

   public void ejbActivate()
      throws EJBException, RemoteException
   {
      log.debug("ejbActivate () called");
   }

   public void ejbPassivate()
      throws EJBException, RemoteException
   {
      log.debug("ejbPassivate () called");
   }

   public void setEntityContext(EntityContext ctx)
      throws EJBException, RemoteException
   {
      log.debug("setEntityContext called");
      this.ctx = ctx;
   }

   public void unsetEntityContext()
      throws EJBException, RemoteException
   {
      log.debug("unsetEntityContext () called");

      ctx = null;
   }

   public abstract void setPk(AccountPK pk);
   public abstract AccountPK getPk();

   public abstract void setPersonsName(String personsName);
   public abstract String getPersonsName();

   public abstract void setPersonsAge(int age);
   public abstract int getPersonsAge();

}
