/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.commerce;

import java.io.Serializable;

/**
 * Simple composite ID class.
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class CompositeId
   implements Serializable
{
   static final long serialVersionUID = -6655894874058441447L;
   public long id;
   public long subId;

   public long getId()
   {
      return id;
   }

   public void setId(long id)
   {
      this.id = id;
   }

   public long getSubId()
   {
      return subId;
   }

   public void setSubId(long subId)
   {
      this.subId = subId;
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof CompositeId)) return false;

      final CompositeId compositeId = (CompositeId)o;

      if(id != compositeId.id) return false;
      if(subId != compositeId.subId) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (int)(id ^ (id >>> 32));
      result = 29 * result + (int)(subId ^ (subId >>> 32));
      return result;
   }
}
