/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.cacheinvalidation.ejb;


import org.jboss.logging.Logger;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class FacadeSessionBean
   implements SessionBean
{
   private static final Logger log = Logger.getLogger(FacadeSessionBean.class);
   SessionContext ctx;

   private transient CLocalHome ch;
   private transient ALocalHome ah;

   // Business methods

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void setup() throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.debug("SETUP>");

      CLocal c = getCLocalHome("CRWLocal").create(new Long(1));
      c.setFirstName("Avoka");

      ALocal a = getALocalHome("ARWLocal").create(new Long(2), "Ataka");
      a.setC(c);

      log.debug("SETUP> done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void tearDown() throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.info("TEAR DOWN>");

      try
      {
         CLocal c = getCLocalHome("CRWLocal").findByPrimaryKey(new Long(1));
         c.remove();
      }
      catch(FinderException e)
      {
      }

      try
      {
         ALocal a = getALocalHome("ARWLocal").findByPrimaryKey(new Long(2));
         a.remove();
      }
      catch(FinderException e)
      {
      }

      log.info("TEAR DOWN> done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public String readFirstName(String jndiName, Long id) throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.info("READ> jndiName=" + jndiName);

      final CLocalHome ch = (CLocalHome) getHome(jndiName);
      CLocal c = ch.findByPrimaryKey(id);

      final String firstName = c.getFirstName();
      log.info(jndiName + ".name=" + firstName);

      log.info("READ> jndiName=" + jndiName + " done in " + (System.currentTimeMillis() - startTime) + " ms.");
      return firstName;
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void writeFirstName(String jndiName, Long id, String name) throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.info("WRITE> jndiName=" + jndiName);

      final CLocalHome ch = (CLocalHome) getHome(jndiName);
      CLocal c = ch.findByPrimaryKey(id);

      c.setFirstName(name);
      log.info(jndiName + ".name=" + c.getFirstName());

      log.info("WRITE> jndiName=" + jndiName + " done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public String readRelatedAFirstName(String jndiName, Long id) throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.info("READ RELATED> jndiName=" + jndiName);

      final CLocalHome ch = (CLocalHome) getHome(jndiName);
      CLocal c = ch.findByPrimaryKey(id);

      final String firstName = c.getA() == null ? null : c.getA().getName();
      log.info(jndiName + ".a.name=" + firstName);

      log.info("READ RELATED> jndiName=" + jndiName + " done in " + (System.currentTimeMillis() - startTime) + " ms.");
      return firstName;
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void removeA(String jndiName, Long id) throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.info("REMOVE> jndiName=" + jndiName);

      final ALocalHome ah = (ALocalHome) getHome(jndiName);
      ALocal a = ah.findByPrimaryKey(id);
      a.remove();

      log.info("REMOVE> jndiName=" + jndiName + " done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

// SessionBean implementation

   /**
    * @throws CreateException Description of Exception
    * @ejb.create-method
    */
   public void ejbCreate() throws CreateException
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void setSessionContext(SessionContext ctx)
   {
      this.ctx = ctx;
   }

   private CLocalHome getCLocalHome(String jndiName)
   {
      if(ch == null)
      {
         ch = (CLocalHome) getHome(jndiName);
      }
      return ch;
   }

   private ALocalHome getALocalHome(String jndiName)
   {
      if(ah == null)
      {
         ah = (ALocalHome) getHome(jndiName);
      }
      return ah;
   }

   private Object getHome(String jndiName)
   {
      try
      {
         InitialContext ctx = new InitialContext();
         return ctx.lookup(jndiName);
      }
      catch(NamingException e)
      {
         throw new IllegalStateException("Failed to look up home " + jndiName + ": " + e.getMessage());
      }
   }
}
