/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.test.cluster.web;

import java.io.Serializable;
import javax.servlet.http.HttpSessionBindingListener;

/**
 * Testing for clustered session binding event.
 * @author Stan Silvert
 */
public class BindingListener implements HttpSessionBindingListener, Serializable
{
   static final long serialVersionUID = -5110742075495287571L;
   private boolean isValueBound = false;
   private boolean isValueUnBound = false;

   /**
    * Creates a new instance of BindingListener
    */
   public BindingListener()
   {
   }

   public void valueBound(javax.servlet.http.HttpSessionBindingEvent httpSessionBindingEvent)
   {
      setValueBound();
   }

   public void valueUnbound(javax.servlet.http.HttpSessionBindingEvent httpSessionBindingEvent)
   {
      setValueUnBound();
   }

   public void setValueBound()
   {
      isValueBound = true;
   }

   public boolean getValueBound()
   {
      return isValueBound;
   }

   public void setValueUnBound()
   {
      isValueUnBound = true;
   }

   public boolean getValueUnBound()
   {
      return isValueUnBound;
   }
}
