/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.classloader.circularity.test;

import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.UnifiedClassLoader3;

/** Extension of the ClassLoadingTask allows access to protected members
 * for testing
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MyClassLoadingTask extends ClassLoadingTask
{
   public MyClassLoadingTask(String classname,
      UnifiedClassLoader3 requestingClassLoader,
      Thread requestingThread)
   {
      super(classname, requestingClassLoader, requestingThread);
   }

   public int threadTaskCount()
   {
      return threadTaskCount;
   }

   public int state()
   {
      return state;
   }

   public Class loadedClass()
   {
      return loadedClass;
   }

   public Throwable loadException()
   {
      return loadException;
   }
}