/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.standAloneAop;

import org.jboss.aop.Advised;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

import java.lang.reflect.Field;
import java.util.*;

/**
 * Proxy to the TreeCacheAop.
 * The AOP framework requires that classes are loaded by special classloaders (e.g UCL).
 */

public class TreeCacheAopTester
{

   TreeCacheAop cache;

   Logger logger_ = Logger.getLogger(TreeCacheAopTester.class);

   public TreeCacheAopTester(String configFile)
   {
      try {
         /*
             cache=new TreeCacheAop(cluster_name, props, 10000);
             cache.startService();
             cache2=new TreeCacheAop(cluster_name, props, 10000);
             cache2.startService();
             */
         cache = new TreeCacheAop();
         PropertyConfigurator config = new PropertyConfigurator();
         config.configure(cache, configFile); // read in generic replSync xml
         cache.startService();
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   public void stop()
   {
      cache.stopService();
   }

   public void testSetup()
   {
      Person p = new Person();
      if (!(p instanceof Advised)) {
         logger_.error("testSetup(): p is not an instance of Advised");
         throw new RuntimeException("Person must be advised!");
      }
      Address a = new Address();
      if (!(a instanceof Advised)) {
         logger_.error("testSetup(): a is not an instance of Advised");
         throw new RuntimeException("Address must be advised!");
      }
   }
   
   public void setSyncCommitPhase(boolean bool) {
      cache.setSyncCommitPhase(true);
   }

   public void createPerson(String key, String name, int age)
   {
      Person p = new Person();
      p.setName(name);
      p.setAge(age);
      p.setAddress(new Address());
      try {
         cache.putObject(key, p);
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public void removePerson(String key)
   {
      try {
         cache.removeObject(key);
      } catch (Exception e) {
         e.printStackTrace();
         throw new RuntimeException(e);
      }
   }

   Object getPerson(String key)
   {
      try {
         return (Person) cache.getObject(key);
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public void createStudent(String key, String name, int age, String year)
   {
      Student p = new Student();
      p.setName(name);
      p.setAge(age);
      p.setAddress(new Address());
      p.setYear(year);
      try {
         cache.putObject(key, p);
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public void removeStudent(String key)
   {
      try {
         cache.removeObject(key);
      } catch (Exception e) {
         e.printStackTrace();
         throw new RuntimeException(e);
      }
   }

   Object getStudent(String key)
   {
      try {
         return (Student) cache.getObject(key);
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public void setYear(String key, String year)
   {
      ((Student) getStudent(key)).setYear(year);
   }

   public String getYear(String key) {
      return ((Student) getStudent(key)).getYear();
   }

   public void setAddress(Person person, Address addr)
   {
      person.setAddress(addr);
   }

   public Address createAddress()
   {
      return new Address();
   }

   public void setName(String key, String name)
   {
      ((Person) getPerson(key)).setName(name);
   }

   public String getName(String key)
   {
      return ((Person) getPerson(key)).getName();
   }

   public void setCurrentStatus(String key, String status)
   {
      ((Person) getPerson(key)).setCurrentStatus(status);
   }

   public String getCurrentStatus(String key)
   {
      return ((Person) getPerson(key)).getCurrentStatus();
   }

   public void setAge(String key, int age)
   {
      ((Person) getPerson(key)).setAge(age);
   }

   public int getAge(String key)
   {
      return ((Person) getPerson(key)).getAge();
   }

   public void setStreet(String key, String street)
   {
      ((Person) getPerson(key)).getAddress().setStreet(street);
   }

   public String getStreet(String key)
   {
      return ((Person) getPerson(key)).getAddress().getStreet();
   }

   public void setCity(String key, String city)
   {
      ((Person) getPerson(key)).getAddress().setCity(city);
   }

   public String getCity(String key)
   {
      return ((Person) getPerson(key)).getAddress().getCity();
   }

   public void setZip(String key, int zip)
   {
      ((Person) getPerson(key)).getAddress().setZip(zip);
   }

   public int getZip(String key)
   {
      return ((Person) getPerson(key)).getAddress().getZip();
   }

   // Map operations

   public Object getHobby(String key, Object hobbyKey)
   {
      Map hobbies = ((Person) getPerson(key)).getHobbies();
      return hobbies == null ? null : hobbies.get(hobbyKey);
   }

   public void setHobby(String key, Object hobbyKey, Object value)
   {
      Person person = ((Person) getPerson(key));
      Map hobbies = person.getHobbies();
      if (hobbies == null) {
         hobbies = new HashMap();
         person.setHobbies(hobbies);
         // NB: it is neccessary to get hobbies again to get advised version
         hobbies = person.getHobbies();
      }
      hobbies.put(hobbyKey, value);
   }

   public void setHobbies(String key, Map map)
   {
      Person person = ((Person) getPerson(key));
      person.setHobbies(map);
   }

   public Map getHobbies(String key) {
      return ((Person) getPerson(key)).getHobbies();
   }
   // List operations

   public Object getLanguage(String key, int index)
   {
      List languages = ((Person) getPerson(key)).getLanguages();
      return languages == null ? null : languages.get(index);
   }

   
   public Object getLanguages(String key)
   {
      List languages = ((Person) getPerson(key)).getLanguages();
      return languages;
   }

   public void addLanguage(String key, Object language)
   {
      Person person = ((Person) getPerson(key));
      List languages = person.getLanguages();
      if (languages == null) {
         person.setLanguages(new ArrayList());
         languages = person.getLanguages();
      }
      languages.add(language);
   }

   public void removeLanguage(String key, Object language)
   {
      List languages = ((Person) getPerson(key)).getLanguages();
      if (languages == null) return;
      languages.remove(language);
   }

   public int getLanguagesSize(String key)
   {
      List languages = ((Person) getPerson(key)).getLanguages();
      return languages == null ? 0 : languages.size();
   }

   public Set getSkills(String key)
   {
      return new HashSet(((Person) getPerson(key)).getSkills());
   }

   public void addSkill(String key, String skill)
   {
      Person person = ((Person) getPerson(key));
      Set skills = person.getSkills();
      if (skills == null) {
         person.setSkills(new HashSet());
         skills = person.getSkills();
      }
      skills.add(skill);
   }

   public void removeSkill(String key, String skill)
   {
      Person person = ((Person) getPerson(key));
      Set skills = person.getSkills();
      if (skills != null) {
         skills.remove(skill);
      }
   }

   public Object testSerialization()
   {
      try {
         Person p = new Person();
         /*
         if (!(p instanceof Externalizable)) {
        throw new RuntimeException("p not Externalizable");
         }
         */
         p.setName("Joe Black");
         Address address = new Address();
         address.setCity("Mannheim");
         p.setAddress(address);
         cache.putObject("/person/joe", p);
         return (Person) cache.getObject("/person/joe");
      } catch (Throwable t) {
         throw new RuntimeException(t);
      }
   }

   public void testDeserialization(String key, Object value)
   {
      try {
         cache.putObject(key, value);
      } catch (Throwable t) {
         throw new RuntimeException(t);
      }
   }

   public void printPerson(String key)
   {
      System.out.println(getPerson(key));
   }

   public void printCache()
   {
      System.out.println(cache.toString());
   }

   public String printCacheDetails()
   {
      return cache.printDetails();
   }

   public Object getFieldValue(String key, String name)
   {
      try {
         Object object = cache.getObject(key);
         Field f = object.getClass().getDeclaredField(name);
         f.setAccessible(true);
         return f.get(object);
      } catch (Exception e) {
         throw new NestedRuntimeException(e);
      }
   }

   public TreeCacheAop getCache()
   {
      return cache;
   }

}

