/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.TestCase;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.logging.Logger;

import java.util.HashMap;
import java.util.Map;

public class RecursiveRefAopTest extends TestCase
{
   private static final String CONFIG_FILENAME = "META-INF/local-service.xml";
   private TreeCacheAop treeCache;
   Logger log = Logger.getLogger(ReplicatedAopTest.class);

   private Map cachedMap;

   public RecursiveRefAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      treeCache = new TreeCacheAop();

      PropertyConfigurator cacheConfig = new PropertyConfigurator();
      cacheConfig.configure(treeCache, CONFIG_FILENAME);
      treeCache.startService();
      treeCache.putObject("/aop/test", new HashMap());
      cachedMap = (Map) treeCache.getObject("/aop/test");
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
   }

   public void testDummy() {

   }

   /**
    * This test feature is not currently supported now since we can't support key is non-primitive object
    * that overrides the hashCode().
    */
   public void XtestRecuriveMapKey()
   {
      try {
         IdObject id = new IdObject("1");
         ValueObject value = new ValueObject(id, 3.0f);
         cachedMap.put(id, value);
      } // try
      catch (Exception x) {
         x.printStackTrace();
         fail("testFailed");
      } // catch
   } // initCache


} // class TestRunner


