/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.standAloneAop;

import java.util.*;


/**
 * Test class for TreeCacheAOP.
 * Person is a POJO that will be instrumented with CacheInterceptor
 *
 * @version $Revision:1$
 */
public class Person
{
   String name = null;
   int age = 0;
   Map hobbies = null;
   Address address = null;
   Set skills;
   List languages;
   // Test for transient field non-replication
   transient String currentStatus = "Active";
   // Test swapping out the Collection ref with proxy one
   // medication will be different when age limit is exceeded.
   List medication = null;
   static final int AGE1 = 50;
   static final int AGE2 = 60;

   public Person() {

   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public void setCurrentStatus(String status) {
      currentStatus = status;
   }

   public String getCurrentStatus() {
      return currentStatus;
   }

   public void setName(Object obj)
   {
      this.name = (String)obj;
   }

   public int getAge()
   {
      return age;
   }

   public void setAge(int age)
   {

      this.age = age;

      // This will swap out the reference dynamically
      if(age < AGE1) {
         if(medication != null) {
            medication.clear();
            medication=null;
         }
      }
      else {
         if( age >= AGE1 ) {
            addMedication("Lipitor");
         }

         if (age >= AGE2) {
            addMedication("Vioxx");
         }
      }


   }

   void addMedication(String name) {
      if( medication == null )
         medication = new ArrayList();
      if(!medication.contains(name))
         medication.add(name);
   }

   public Map getHobbies()
   {
      return hobbies;
   }

   public void setHobbies(Map hobbies)
   {
      this.hobbies = hobbies;
   }

   public Address getAddress()
   {
      return address;
   }

   public void setAddress(Address address)
   {
      this.address = address;
   }

   public Set getSkills()
   {
      return skills;
   }

   public void setSkills(Set skills)
   {
      this.skills = skills;
   }

   public List getMedication()
   {
      return medication;
   }

   public void setMedication(List medication)
   {
      this.medication = medication;
   }

   public List getLanguages()
   {
      return languages;
   }

   public void setLanguages(List languages)
   {
      this.languages = languages;
   }

   public String toString()
   {
      StringBuffer sb=new StringBuffer();
      sb.append("name=").append(getName()).append(", age=").append(getAge()).append(", hobbies=")
            .append(print(getHobbies())).append(", address=").append(getAddress()).append(", skills=")
            .append(skills).append(", languages=").append(languages).toString();
      if(medication != null)
         sb.append(", medication=" + medication);
      return sb.toString();
   }

   public String print(Map m)
   {
      StringBuffer sb = new StringBuffer();
      Map.Entry entry;
      if (m != null) {
         for (Iterator it = m.entrySet().iterator(); it.hasNext();) {
            entry = (Map.Entry) it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue());
            sb.append("\n");
         }
      }
      return sb.toString();
   }
}
