/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.CacheException;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.transaction.DummyTransactionManager;

import javax.naming.Context;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;


/**
 * Test out the Collection proxy generation.
 *
 * @version $Revision:1$
 * @author<a href="mailto:bwang@jboss.org">Ben Wang</a> December 2004
 */
public class CollectionProxyAopTest extends TestCase
{
   static TreeCacheAop cache_;
   int cachingMode_ = TreeCache.LOCAL;

   public CollectionProxyAopTest(String name)
   {
      super(name);
   }

   public void setUp() throws Exception
   {
      super.setUp();
      initCaches(TreeCache.LOCAL);

      log("LocalConcurrentTestCase: cacheMode=TRANSIENT, one cache");
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
      destroyCaches();
   }

   void initCaches(int caching_mode) throws Exception
   {
      cachingMode_ = caching_mode;
      cache_ = new TreeCacheAop();
      PropertyConfigurator config = new PropertyConfigurator();
      config.configure(cache_, "META-INF/local-aop-eviction-service.xml"); // read in generic local xml
      cache_.createService();
      cache_.startService();
   }

   void destroyCaches() throws Exception
   {
      cache_.stopService();
      cache_ = null;
   }

   public void testListSubClass() throws Exception
   {
      String node = "/aop/list";
      MyList list = new MyList();
      list.add("Ben");
      cache_.putObject(node, list);
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(CollectionProxyAopTest.class);
   }

   private static void log(String str)
   {
      System.out.println("Thread: " + Thread.currentThread() + ": " + str);
//        System.out.println(str);
   }

   public static class MyList extends ArrayList
   {
      public MyList()
      {
         super();
      }
      // Just a place holder to test out the proxy generation
   }
}
