/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.CacheException;

import java.util.*;


/**
 * Generic Collection class support testing.
 */

public class CollectionAopTest extends TestCase
{
   Logger log = Logger.getLogger(CollectionAopTest.class);
   TreeCacheAopTester tester;
   TreeCacheAop cache;

   public CollectionAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      tester = new TreeCacheAopTester(configFile);

      cache = tester.getCache();
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester = null;
   }

   /**
    * Testing using LinkedList proxy.
    * @throws Exception
    */
   public void testLinkedList() throws Exception {
      LinkedList list = new LinkedList();
      LinkedList list1;
      list.add("English");
      try {
         cache.putObject("/aop/list", list);
         list = (LinkedList)cache.getObject("/aop/list");
         list.add("French");
         list1 = (LinkedList)cache.getObject("/aop/list");
         assertEquals("Size of list ", 2, list1.size());
      } catch (CacheException e) {
         fail("pubtObject fails");
         throw e;
      }
   }

   /**
    * Testing using LinkedMap proxy.
    * @throws Exception
    */
   public void testLinkedMap() throws Exception {
      LinkedHashMap map = new LinkedHashMap();
      LinkedHashMap map1;
      map.put("1", "English");
      try {
         cache.putObject("/aop/map", map);
         map = (LinkedHashMap)cache.getObject("/aop/map");
         map.put("2", "French");
         map1 = (LinkedHashMap)cache.getObject("/aop/map");
         assertEquals("Size of map ", 2, map1.size());
      } catch (CacheException e) {
         fail("pubtObject fails");
         throw e;
      }
   }

   /**
    * Testing using LinkedSet proxy.
    * @throws Exception
    */
   public void testLinkedSet() throws Exception {
      LinkedHashSet set = new LinkedHashSet();
      LinkedHashSet set1;
      set.add("English");
      Map map;
      try {
         cache.putObject("/aop/set", set);
         set = (LinkedHashSet)cache.getObject("/aop/set");
         set.add("French");
         set1 = (LinkedHashSet)cache.getObject("/aop/set");
         assertEquals("Size of set ", 2, set1.size());
      } catch (CacheException e) {
         fail("pubtObject fails");
         throw e;
      }
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(CollectionAopTest.class);
   }

   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

