/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;

import java.util.*;

//import org.jboss.test.JBossTestCase;


/**
 * Set interface testing.
 */

public class CachedSetAopTest extends TestCase
{
   Logger log = Logger.getLogger(CachedSetAopTest.class);
   TreeCacheAopTester tester;
   Set skills;

   public CachedSetAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/replSync-service.xml";
      tester = new TreeCacheAopTester(configFile);
      tester.createPerson("/person/test7", "p7", 27);
      tester.addSkill("/person/test7", "Java");
      tester.addSkill("/person/test7", "C++");
      tester.addSkill("/person/test7", "Perl");
      skills = tester.getSkills("/person/test7");
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester = null;
   }

   public void testAddAndRemoveIndex() throws Throwable
   {
      int size = skills.size();
      assertEquals("Size is ", 3, size);

      skills.add("Golf");
      size = skills.size();
      assertEquals("Size is ", 4, size);

      skills.add("Golf");
      size = skills.size();
      assertEquals("Size is ", 4, size);

      assertTrue("Skill contain Golf ", skills.contains("Golf"));

      skills.remove("C++");
      size = skills.size();
      assertEquals("Size is ", 3, size);
      assertFalse("Skill does not contain C++ anymore ", skills.contains("C++"));

      skills.clear();
      size = skills.size();
      assertEquals("Size is ", 0, size);

      assertTrue("Should be empty", skills.isEmpty());
   }

   public void testAddAndRemoveAll() throws Throwable
   {
      int size = skills.size();
      assertEquals("Size is ", 3, size);

      List list = new ArrayList();
      list.add("Tennis");
      list.add("Polo");
      list.add("Baseball");

      skills.addAll((Collection)list);
      size = skills.size();
      assertEquals("Size is ", 6, size);
      assertTrue("Skill contains Polo ", skills.contains("Polo"));

      skills.removeAll((Collection)list);
      size = skills.size();
      assertEquals("Size is ", 3, size);
      assertFalse("Skill does not contain Polo ", skills.contains("Polo"));
      assertTrue("Skill contains C++ ", skills.contains("C++"));

   }

   public void testIterator() {
      Iterator it = skills.iterator();
      int counter = 0;
      while(it.hasNext()) {
         counter++;
         it.next();
         it.remove();
      }

      assertEquals("Size should be ", 3, counter);
      assertEquals("Skills should be empty ", 0, skills.size());
   }

   public void testEquals() throws Throwable {
      Set set = (Set)tester.getSkills("/person/test7");
      assertTrue("List should be the same ", set.equals(skills));
      set = new HashSet();
      set.add("German");
      set.add("test");
      set.add("English");
      assertFalse("List should not be the same ", set.equals(skills));
      assertFalse("List should not be the same ", skills.equals(set));
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(CachedSetAopTest.class);
   }

   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

