/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.TreeCacheAop;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Iterator;

//import org.jboss.test.JBossTestCase;


/**
 * Set interface testing.
 * @author Ben Wang
 */

public class CachedMapAopTest extends TestCase
{
   Logger log = Logger.getLogger(CachedMapAopTest.class);
   TreeCacheAopTester tester;
   Map hobbies;

   public CachedMapAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/replSync-service.xml";
      tester = new TreeCacheAopTester(configFile);
      tester.createPerson("/person/test7", "p7", 27);
      tester.setHobby("/person/test7", "1", "golf");
      tester.setHobby("/person/test7", "2", "tennis");
      tester.setHobby("/person/test7", "3", "polo");
      hobbies = tester.getHobbies("/person/test7");
      System.out.println("Cache: "+ tester.getCache().printDetails());
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester = null;
   }

   /**
    * Test simple put
    * @throws Throwable
    */
   public void testPut() throws Throwable {
      Map map = new HashMap();
      map.put("4", "pingpong");
      map.put("5", "handball");

      tester.setHobbies("/person/test7", map);
      hobbies = tester.getHobbies("/person/test7");
      if( !(hobbies instanceof ClassProxy || hobbies instanceof Map) ) {
         fail("testPut(): hobbies is not instance of ClassProxy nor Map");
      }

      int size = hobbies.size();
      assertEquals("Size is ", 2, size);

      hobbies.put("6", "baseball");
      hobbies = tester.getHobbies("/person/test7");
      size = hobbies.size();
      assertEquals("Size is ", 3, size);

   }

   public void testAddAndRemoveIndex() throws Throwable
   {
      int size = hobbies.size();
      assertEquals("Size is ", 3, size);

      hobbies.put("4", "baseball");
      size = hobbies.size();
      assertEquals("Size is ", 4, size);

      assertTrue("Skill contain Golf ", hobbies.containsKey("3"));

      hobbies.remove("3");
      size = hobbies.size();
      assertEquals("Size is ", 3, size);
      assertFalse("Skill does not contain 3 anymore ", hobbies.containsKey("3"));

      hobbies.clear();
      size = hobbies.size();
      assertEquals("Size is ", 0, size);

      assertTrue("Should be empty", hobbies.isEmpty());
   }

   public void testPutAllEtc() throws Throwable {
      int size = hobbies.size();
      assertEquals("Size is ", 3, size);

      Map map = new HashMap();
      map.put("4", "pingpong");
      map.put("5", "handball");

      hobbies.putAll(map);
      size = hobbies.size();
      assertEquals("Size is ", 5, size);

      assertTrue("Key is ", hobbies.containsKey("4"));

      Set keys = hobbies.keySet();
      assertEquals("Key size ", 5, keys.size());

      Set entries = hobbies.entrySet();
      assertEquals("Entry size ", 5, entries.size());

   }

   public void testEntrySet() throws Throwable {
      Fqn fqn = Fqn.fromString("/person/test7");
      TreeCacheAop cache = tester.getCache();
      Map map = tester.getHobbies("/person/test7");
      System.out.println("Map "+ map.toString());
      for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
         Map.Entry entry = (Map.Entry) i.next();
         System.out.println("Entry key and value "+ entry.getKey()+ " "+ entry.getValue());
      }
   }

   public void testEquals() throws Throwable {
      Map map = tester.getHobbies("/person/test7");
      assertTrue("Map should be the same ", map.equals(hobbies));
      map = new HashMap();
      map.put("1", "test");
      map.put("4", "test");
      map.put("2", "tennis");
      assertFalse("Map should not be the same ", map.equals(hobbies));
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(CachedMapAopTest.class);
   }

   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

